# AI Tools Explorer - WordPress Export

This folder contains the files needed to convert this static site into a WordPress theme or to upload it to a WordPress installation with Elementor.

## How to Use with WordPress and Elementor

### Option 1: As a WordPress Theme

1. Compress the entire project into a ZIP file
2. In your WordPress admin, go to Appearance > Themes > Add New > Upload Theme
3. Upload the ZIP file and activate the theme

### Option 2: Import into Elementor

1. Make sure you have WordPress installed with Elementor and Elementor Pro
2. Create a new page in WordPress
3. Edit with Elementor
4. Import the `elementor-template.json` file from this folder using Elementor's import feature

## File Structure

- `elementor-template.json` - The Elementor template export file
- `style.css` - The WordPress theme style file
- `functions.php` - The WordPress theme functions file
- `screenshot.png` - The theme screenshot for WordPress admin

## Customization

After importing into WordPress/Elementor, you can:

1. Update the AI tool entries in the database
2. Customize the colors and styles through Elementor or the WordPress Customizer
3. Add your own logo and branding
4. Connect forms to your email marketing provider

## Additional Resources

For more information on how to customize this theme in WordPress, refer to:
- [WordPress Theme Documentation](https://developer.wordpress.org/themes/)
- [Elementor Documentation](https://elementor.com/help/)